/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.BlindSearch;
import com.mckoi.database.CollatedBaseSearch;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.Privileges;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.TObject;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableName;
import com.mckoi.util.BigNumber;

public class GTPrivMapDataSource
extends GTDataSource {
    private static int BIT_COUNT = 11;
    static final DataTableDef DEF_DATA_TABLE_DEF;

    public GTPrivMapDataSource(DatabaseConnection connection) {
        super(connection.getSystem());
    }

    public DataTableDef getDataTableDef() {
        return DEF_DATA_TABLE_DEF;
    }

    public int getRowCount() {
        return (1 << BIT_COUNT) * BIT_COUNT;
    }

    public TObject getCellContents(int column, int row) {
        int c1 = row / BIT_COUNT;
        if (column == 0) {
            return this.columnValue(column, BigNumber.fromInt(c1));
        }
        int priv_bit = 1 << row % BIT_COUNT;
        String priv_string = null;
        if ((c1 & priv_bit) != 0) {
            priv_string = Privileges.formatPriv(priv_bit);
        }
        return this.columnValue(column, priv_string);
    }

    public SelectableScheme getColumnScheme(int column) {
        if (column == 0) {
            return new PrivMapSearch(this, column);
        }
        return new BlindSearch(this, column);
    }

    static {
        DataTableDef def = new DataTableDef();
        def.setTableName(new TableName("SYS_INFO", "sUSRPrivMap"));
        def.addColumn(GTPrivMapDataSource.numericColumn("priv_bit"));
        def.addColumn(GTPrivMapDataSource.stringColumn("description"));
        def.setImmutable();
        DEF_DATA_TABLE_DEF = def;
    }

    private static final class PrivMapSearch
    extends CollatedBaseSearch {
        PrivMapSearch(TableDataSource table, int column) {
            super(table, column);
        }

        public SelectableScheme copy(TableDataSource table, boolean immutable) {
            return new BlindSearch(table, this.getColumn());
        }

        protected int searchFirst(TObject val) {
            if (val.isNull()) {
                return -1;
            }
            int num = ((BigNumber)val.getObject()).intValue();
            if (num < 0) {
                return -1;
            }
            if (num > 1 << BIT_COUNT) {
                return -((1 << BIT_COUNT) * BIT_COUNT + 1);
            }
            return num * BIT_COUNT;
        }

        protected int searchLast(TObject val) {
            int p = this.searchFirst(val);
            if (p >= 0) {
                return p + (BIT_COUNT - 1);
            }
            return p;
        }
    }
}

